/************************************************************/
/* PROJECT NAME: MAM	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V2.00b		                    */
/* Assembler:    	            			                */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Demo of Memory Accelerator Module performance	*/
/*															*/
/* Demonstrates Use of the LPC2100 MAM	    				*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB21000								*/
/************************************************************/

#include <LPC21xx.H> 

void ChangeGPIOPinState(unsigned int state);

unsigned val;


int main(void)
{
unsigned int delay;
unsigned int flasher = 0x00010000; 						// define locals

IODIR1 		= 0x00FF0000; 									// set all ports to output

VPBDIV 		= 0x00000002;

ADCR   		= 0x00270601;                     				// Setup A/D: 10-bit AIN0 @ 3MHz 
ADCR 		|= 0x01000000;                      				// Start A/D Conversion 

while(1)
{
do
{
    val 	= ADDR;                            				// Read A/D Data Register 
}        
while ((val & 0x80000000) == 0x00000000);
val 		= ((val >> 6) & 0x000003FF);

if (val <0x0000000080)
{
MAMCR 		= 0x00000000;								 //switch off the MAM
MAMTIM 		= ;				//Set access time	(0x04)
MAMCR 		= ;				//Switch MAM fully on (0x02)
}
else
{
MAMCR 		= 0x00000000;								 //Switch off MAM
}

for(delay = 0;delay<0x100000;delay++)				  	//simple delay loop
{
;
}

ChangeGPIOPinState(flasher);							//set the state of the ports
flasher = flasher <<1;									//shift the active led
if(flasher&0x01000000) flasher = 0x00010000;			//Increment flasher led and test for overflow

}
}

void ChangeGPIOPinState(unsigned int state)
{
IOCLR1 = ~state;  										//clear output pins
IOSET1 =  state;										//set output pins

}


